
#ifndef LLF_ECPKI_ELGAMAL_DB_DEF_H
#define LLF_ECPKI_ELGAMAL_DB_DEF_H
/*
 * This file is included in the middle of the struct declaration for CRYS_ECPKI data types
 * It contains the platform-specific parts of the context struct. As such:
 *
 *  1) file should not use any includes it is a part of the CRYS_ECPKI_Types.h file !!!!
 *  2) only the CRYS_ECPKI_Types.h file should include this file. 
 */
  /*
   *  Object %name    : 
   *  State           :  %state%
   *  Creation date   :  28/05/2006
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A abow stated brief description of this module
   *
   *  \version LLF_ECPKI_elgamal_db_def.h#1:incl:1
   *  \author R.Levin
   *  \remarks Copyright (C) 2006 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

   /*  Size = 44*CRYS_ECPKI_MODUL_MAX_LENGTH_IN_WORDS  =
	= (1+2+2+2+1)*CRYS_ECPKI_MODUL_MAX_LENGTH_IN_WORDS + 
	  (sizeof(LLF_ECPKI_elgamal_db_def.h) = 36*CRYS_ECPKI_MODUL_MAX_LENGTH_IN_WORDS + 1) */

	  struct
	  {	
  	   	  DxUint32_t               k[CRYS_ECPKI_MODUL_MAX_LENGTH_IN_WORDS + 1];
		  CRYS_ECPKI_PointAffine_t Point1;
		  CRYS_ECPKI_PointAffine_t Point2;
		  CRYS_ECPKI_PointAffine_t Point3;
		  CRYS_ECPKI_PointAffine_t Point4;  
		    
      	  DxUint32_t  m[CRYS_ECPKI_MODUL_MAX_LENGTH_IN_WORDS + 1];
      	  DxUint32_t  mSizeBytes;
      	  
      	  DxUint32_t  EphemerPrivKey[CRYS_ECPKI_MODUL_MAX_LENGTH_IN_WORDS + 1];
      	  DxUint32_t  EphemerPrivKeySizeBytes;
      	  
      	  DxUint32_t  EphemerPublKeyX[CRYS_ECPKI_MODUL_MAX_LENGTH_IN_WORDS];
      	  DxUint32_t  EphemerPublKeyY[CRYS_ECPKI_MODUL_MAX_LENGTH_IN_WORDS];
   
      	  /* Temporary buffers used for the EC scalar multiplication and adding */
	      DxUint32_t TempBuff[CRYS_ECPKI_MODUL_MAX_LENGTH_IN_WORDS * 60 ];

      }LLF;
   
#endif


